//
//  COFont.h
//  GSFontTools
//
//  Created by Georg Seifert on 10.08.11.
//  Copyright 2011 schriftgestaltung.de. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import <GSFontTools/TTFont.h>
//@class TTFont;
//@class MGOrderedDictionary;
@class COInfo;
@class COGSUB;
@class COGPOS;
@class OTGDEF;

@class COGlyph;

NSMutableDictionary *reverseCMAP(NSDictionary *Cmap);

@interface COFont : NSObject {
	NSString *_path;
	NSString *_fallbackGlyph;
	NSMutableDictionary *_glyphsDict;
	TTFont *_source;
	Class _glyphClass;
	//	MGOrderedDictionary * _cmap;
	//	MGOrderedDictionary * _reversedCmap;
	NSMutableDictionary *_cmap;
	NSMutableDictionary *_reversedCmap;

	NSArray *_glyphs;
	NSArray *_glyphOrder;
	COInfo *_info;
	COGSUB *_gsub;
	COGPOS *_gpos;
	OTGDEF *_gdef;
}
@property (nonatomic, retain) NSMutableDictionary *glyphsDict;
@property (nonatomic, retain) NSMutableDictionary *cmap;
@property (nonatomic, retain) NSArray *glyphOrder;
@property (nonatomic, retain) COInfo *info;
@property (nonatomic, readonly) TTFont *source;
@property (nonatomic, retain) NSArray *glyphs;
@property (nonatomic, retain) OTGDEF *gdef;
@property (nonatomic, retain) COGSUB *gsub;

- (id)initWithPath:(NSString *)path glyphClass:(Class)glyphClass;

- (void)loadCMAP;
- (void)loadGlyphSet;
- (void)loadInfo;
- (void)loadFeatures;
- (void)resetFeatureStates;
- (void)setFeatureState:(BOOL)state forTag:(NSString *)featureTag;

/**
 Description

 @param GlyphRecords The glyph records to process. Please note that this array is no longer modified but a shallow copy is made first.
 @param theScriptTag theScriptTag description
 @param theLangSysTag theLangSysTag description
 @param RightToLeft RightToLeft description
 @return The processed glyph records.
 */
- (NSArray *)processGlyphRecords:(NSArray *)glyphRecords
						  script:(NSString *)theScriptTag
					  langSysTag:(NSString *)theLangSysTag
					 rightToLeft:(BOOL)rightToLeft;

//- (NSArray *)process:(NSString*)string
//			  script:(NSString*)theScriptTag
//		  langSysTag:(NSString*)theLangSysTag
//		 rightToLeft:(BOOL)rightToLeft;

//- (NSArray *)processAttributed:(NSAttributedString*)attributedString
//						script:(NSString*)theScriptTag
//					langSysTag:(NSString*)theLangSysTag
//				   rightToLeft:(BOOL)rightToLeft;

- (COGlyph *)glyphForName:(NSString *)name;

@end

@interface COInfo : NSObject {
	NSArray *_names;
  @public
	NSUInteger unitsPerEm;
	NSUInteger ascender;
	NSInteger descender;
	NSUInteger winAscender;
	NSInteger winDescender;
	NSUInteger xHeight;
	NSUInteger capHeight;
	CGFloat italicAngle;
}
@property (strong) NSArray *names;
@end
